Attribute VB_Name = "mod_SettingsFile"
Public strSetFile As String                         'Filename for Demo program settings
Public strCard As String                            'GPIB Card type

Public Const OF_EXIST = &H4000                      'Constant for determining if a file exists (frmGPIBsettings)

Type OFSTRUCT                                       'Type for file exist determination
  cBytes As Byte
  fFixedDisk As Byte
  nErrCode As Integer
  Reserved1 As Integer
  Reserved2 As Integer
  szPathName As String * 128
End Type

Declare Function OpenFile Lib "kernel32" (ByVal lpFileName As String, _
                              lpReOpenBuff As OFSTRUCT, _
                              ByVal wStyle As Long) As Long         'Function to check if file open

Public Sub StoreSetting(strFileName As String)
'Stores settings in a file

Open strFileName For Output As #2

'Writes the data into the file number #2
Print #2, strCard
Print #2, frmGPIBSettings.txt2510GPIB.Text

Close #2                    'Close file

End Sub

Public Sub ReadSetting(strFileName As String)
'Reads settings from file and
'extracts settings to program variables
Dim strGPIBCard As String
Dim str2510Addr

Open strFileName For Input As #2     'Open File
Line Input #2, strGPIBCard              'Read GPIB Card Data
Line Input #2, str2510Addr              'Read GPIB Card Data
Close #2

'Set variables from stored settings
If strGPIBCard = "CEC" Then
    frmGPIBSettings.CommOpt(0).value = True
    Else
    frmGPIBSettings.CommOpt(1).value = True
End If
DoEvents

intKI2510 = CInt(str2510Addr)

End Sub

Function FileExists(strFile As String) As Boolean
'Checks for the existence of a file based on path and filename

Dim WD As String

On Error GoTo FileErr
    WD = Environ$("windir")
    If Dir$(CurDir$ & "\" & strSetFile, 0) <> "" Then       'True will return path+filename
        FileExists = True
    ElseIf Dir$(WD & "\" & strSetFile, 0) <> "" Then        'True will return path+filename
        FileExists = True
    Else
        FileExists = False
    End If

Exit Function

FileErr:
    MsgBox "Error processing " & strSetFile & vbCrLf & "Please enter GPIB card and address(es) before re-saving setup.", MB_ICONSTOP, "File I/O Error"
    End
End Function

